uniform sampler2D s_tex0; 

uniform float exposure;

uniform vec4 u_blendcolor;

varying vec2 v_texcoord;

void main()
{	
	vec4 color = texture2D(s_tex0, v_texcoord) * u_blendcolor;

	// balance is based on the eye
	float Y = dot(vec4(0.30, 0.59, 0.11, 1.0), color);
	vec4 ldrColor = (1.0 - exp2 (-color * exposure)) * Y;
	ldrColor.a = 1.0;

	// Sampling The Texture And Passing It To The Frame Buffer
	gl_FragColor = ldrColor;
} 
